/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.netdiag;

import com.ibm.hwmca.base.netdiag.NetDiagErrorIds;
import com.ibm.hwmca.base.netdiag.NetDiagInfoBean;
import com.ibm.hwmca.base.netdiag.NetDiagRequests;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.LinuxRequiredException;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class NetworkDiagnosticInfoTasklet
extends PanelTasklet
implements NetDiagErrorIds,
NetDiagRequests {
    private static final String TRACE_MASKT = "HNTDT MT";
    private static final String TRACE_MASKF = "HNTDT MF";
    private static final String TRACE_MASKD = "HNTDT MD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.netdiag.res.NetworkDiagnosticInformationRes";
    private static final String TEMP_FILE_PREFIX = "NetDiag";
    private File tempDir;
    private NetDiagInfoBean bean;
    private static final String TEMP_PATH_KEY = "tmp";
    private static final String NETDIAG_PANEL_NAME = "NetworkDiagnosticInfoPanel";
    private static final String[] NOT_SUPPORTED = new String[]{"This command is not yet supported."};
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "NetworkDiag");
    private static Map commandMap = new HashMap();

    public NetworkDiagnosticInfoTasklet() {
        Trace.trace(TRACE_MASKT, "<> NetworkDiagnosticInfoTasklet.NetworkDiagnosticInfoTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> NetworkDiagnosticInfoTasklet.service()");
        try {
            if (request.isInitialRequest()) {
                this.serviceInitialRequest(request, response);
            } else if (request.isDisposed() || request.isCanceled()) {
                Trace.trace(TRACE_MASKF, "   terminating the tasklet");
                response.terminate();
            } else {
                String requestName = (String)request.getData("Request");
                Trace.trace(TRACE_MASKF, "   requestName is [" + requestName + "]");
                if (requestName.equals("PingPanel")) {
                    String ipAddress = (String)request.getData("IpAddress");
                    this.executeCommand("ping " + ipAddress + " -s 100 -c 5 -w 10", response);
                } else {
                    String command = (String)commandMap.get(requestName);
                    if (command != null) {
                        this.executeCommand(command, response);
                    } else {
                        Trace.trace(TRACE_MASKF, "   terminating the tasklet");
                        response.terminate();
                    }
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "   exception during service: " + exc);
            if (exc instanceof TaskletException) {
                throw (TaskletException)exc;
            }
            throw new TaskletException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- NetworkDiagnosticInfoTasklet.service()");
    }

    private void serviceInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException, LinuxRequiredException {
        Trace.trace(TRACE_MASKF, "-> NetworkDiagnosticInfoTasklet.serviceInitialRequest()");
        if (!CommonSystem.getCommonSystem().isLinux()) {
            throw new LinuxRequiredException();
        }
        this.bean = new NetDiagInfoBean();
        response.replace(AUIML_FILE_NAME, NETDIAG_PANEL_NAME, this.bean);
        Trace.trace(TRACE_MASKF, "<- NetworkDiagnosticInfoTasklet.serviceInitialRequest()");
    }

    public void logException(Throwable thr) {
        System.out.println("   caught exception " + thr);
        thr.printStackTrace();
    }

    private File getTempFile() throws TaskletException {
        try {
            if (this.tempDir == null) {
                this.tempDir = new File(BaseFileControl.getFilePath(TEMP_PATH_KEY));
            }
            return File.createTempFile(TEMP_FILE_PREFIX, ".tmp", this.tempDir);
        }
        catch (IOException exc) {
            throw new TaskletException(exc);
        }
        catch (HException exc) {
            throw new TaskletException(exc);
        }
    }

    void executeCommand(String command, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> NetworkDiagnosticInfoTasklet.executeCommand()");
        File tempFile = null;
        Object text = null;
        try {
            tempFile = this.getTempFile();
            FileOutputStream tempOut = new FileOutputStream(tempFile.getAbsolutePath());
            String[] commandArray = this.getCommandArray(command);
            Process process = Runtime.getRuntime().exec(commandArray);
            StreamIOThread thread = new StreamIOThread(process.getInputStream(), tempOut);
            thread.run();
            try {
                thread.join(5000L);
                process.waitFor();
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            int exitValue = process.exitValue();
            Trace.trace(TRACE_MASKF, "   exit value is " + exitValue);
            process.destroy();
            if (exitValue == 0) {
                response.update(this.getFileContents(tempFile));
            } else {
                String[] result = new String[]{"Command failed, exit value from command is " + exitValue, "The command was [" + command + "]."};
                response.update(result);
            }
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace();
            throw new TaskletException(ioexc);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        Trace.trace(TRACE_MASKF, "<- NetworkDiagnosticInfoTasklet.executeCommand()");
    }

    private String[] getCommandArray(String command) {
        Trace.trace(TRACE_MASKF, "-> NetworkDiagnosticInfoTasklet.getCommandArray()");
        Trace.trace(TRACE_MASKF, "  will execute command [" + command.toString() + "]");
        StringTokenizer tokenizer = new StringTokenizer(command.toString());
        int numTokens = tokenizer.countTokens();
        String[] commandArray = new String[numTokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            commandArray[i] = tokenizer.nextToken();
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- NetworkDiagnosticInfoTasklet.getCommandArray()");
        return commandArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getFileContents(File tempFile) throws IOException {
        String[] result;
        block13: {
            Trace.trace(TRACE_MASKF, "-> NetworkDiagnosticInfoTasklet.getFileContents()");
            result = null;
            BufferedReader inStream = null;
            try {
                block12: {
                    if (tempFile.length() > 0L) {
                        inStream = new BufferedReader(new FileReader(tempFile));
                        char[] data = new char[(int)tempFile.length()];
                        if (inStream.read(data, 0, (int)tempFile.length()) == -1) {
                            Trace.trace(TRACE_MASKF, "  could not read file");
                            break block12;
                        } else {
                            ArrayList<String> lines = new ArrayList<String>();
                            int size = 0;
                            StringTokenizer tokenizer = new StringTokenizer(new String(data), "\n");
                            while (tokenizer.hasMoreTokens()) {
                                String text = this.trim(tokenizer.nextToken());
                                if (text.length() == 0) {
                                    if (size <= 0) continue;
                                    ++size;
                                    lines.add(" ");
                                    continue;
                                }
                                ++size;
                                lines.add(this.fixText(text));
                            }
                            result = lines.toArray(new String[lines.size()]);
                            Trace.trace(TRACE_MASKD, "   number of lines to display is " + result.length);
                        }
                        break block12;
                    }
                    result = new String[]{"The exit value from the command was 0 but no data was received."};
                }
                Object var10_10 = null;
                if (inStream == null) break block13;
                try {
                    inStream.close();
                }
                catch (IOException exc) {
                    Trace.trace(TRACE_MASKF, "   error closing inStream, exc is " + exc);
                    throw exc;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (inStream == null) throw throwable;
                try {}
                catch (IOException exc) {
                    Trace.trace(TRACE_MASKF, "   error closing inStream, exc is " + exc);
                    throw exc;
                }
                inStream.close();
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKF, "<- NetworkDiagnosticInfoTasklet.getFileContents()");
        return result;
    }

    private String fixText(String text) {
        return this.trim(text);
    }

    private String trim(String text) {
        int next;
        for (next = text.length() - 1; next > 0 && Character.isWhitespace(text.charAt(next)); --next) {
        }
        text = text.substring(0, next + 1);
        return text;
    }

    static {
        commandMap.put("InterfacesPanel", "netstat -in");
        commandMap.put("IcmpPanel", "netstat -c");
        commandMap.put("MemoryBuffersPanel", "netstat -m");
        commandMap.put("AddressPanel", "/sbin/ifconfig");
        commandMap.put("ArpPanel", "cat /proc/net/arp");
        commandMap.put("RoutesPanel", "netstat -rn");
        commandMap.put("SocketsPanel", "netstat -an");
        commandMap.put("UdpPanel", "netstat -un");
        commandMap.put("IpPanel", "netstat -tn");
        commandMap.put("TcpPanel", "netstat");
        commandMap.put("NativeConnectionsPanel", "iqzzqtcs");
    }

    class StreamIOThread
    extends Thread {
        private InputStream inStream;
        private FileOutputStream outStream;

        StreamIOThread(InputStream in, FileOutputStream out) {
            this.inStream = in;
            this.outStream = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block9: {
                int c;
                while ((c = this.inStream.read()) != -1) {
                    this.outStream.write(c);
                }
                Object var3_3 = null;
                try {
                    this.outStream.close();
                }
                catch (IOException exc2) {
                    Trace.trace(NetworkDiagnosticInfoTasklet.TRACE_MASKF, "   error closing outStream, exc is " + exc2);
                }
                break block9;
                {
                    catch (IOException exc) {
                        Trace.trace(NetworkDiagnosticInfoTasklet.TRACE_MASKF, "   error writing temp file, exc is " + exc);
                        exc.printStackTrace();
                        Object var3_4 = null;
                        try {
                            this.outStream.close();
                        }
                        catch (IOException exc2) {
                            Trace.trace(NetworkDiagnosticInfoTasklet.TRACE_MASKF, "   error closing outStream, exc is " + exc2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        this.outStream.close();
                    }
                    catch (IOException exc2) {
                        Trace.trace(NetworkDiagnosticInfoTasklet.TRACE_MASKF, "   error closing outStream, exc is " + exc2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

